/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.logic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.mojang.logging.LogUtils;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bettercombat.BetterCombatMod;
import net.bettercombat.Platform;
import net.bettercombat.api.AttributesContainer;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.api.WeaponAttributesHelper;
import net.bettercombat.api.component.BetterCombatDataComponents;
import net.bettercombat.network.Packets;
import net.bettercombat.utils.CompressionHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class WeaponRegistry {
    static final Logger LOGGER = LogUtils.getLogger();
    static Map<class_2960, WeaponAttributes> registrations = new HashMap<class_2960, WeaponAttributes>();
    static Map<class_2960, AttributesContainer> containers = new HashMap<class_2960, AttributesContainer>();
    private static Encoded encodedRegistrations = new Encoded(true, List.of());
    private static final int CHUNK_SIZE = 10000;
    private static final Gson gson = new GsonBuilder().create();

    public static void register(class_2960 itemId, WeaponAttributes attributes) {
        registrations.put(itemId, attributes);
    }

    static WeaponAttributes getAttributes(class_2960 itemId) {
        return registrations.get(itemId);
    }

    public static WeaponAttributes getAttributes(class_1799 itemStack) {
        AttributesContainer container;
        if (itemStack == null) {
            return null;
        }
        class_2960 component = (class_2960)itemStack.method_57824(BetterCombatDataComponents.WEAPON_PRESET_ID);
        if (component != null && (container = containers.get(component)) != null) {
            return container.attributes();
        }
        class_1792 item = itemStack.method_7909();
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        return WeaponRegistry.getAttributes(id);
    }

    public static void loadAttributes(class_3300 resourceManager) {
        WeaponRegistry.loadContainers(resourceManager);
        containers.forEach((itemId, container) -> {
            if (!class_7923.field_41178.method_10250(itemId)) {
                return;
            }
            WeaponRegistry.resolveAndRegisterAttributes(itemId, container);
        });
    }

    private static void loadContainers(class_3300 resourceManager) {
        Gson gson = new Gson();
        HashMap<class_2960, AttributesContainer> containers = new HashMap<class_2960, AttributesContainer>();
        for (Map.Entry entry : resourceManager.method_14488("weapon_attributes", fileName -> fileName.method_12832().endsWith(".json")).entrySet()) {
            class_2960 identifier = (class_2960)entry.getKey();
            class_3298 resource = (class_3298)entry.getValue();
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.method_14482()));
                AttributesContainer container = WeaponAttributesHelper.decode(reader);
                String id = identifier.toString().replace("weapon_attributes/", "");
                id = id.substring(0, id.lastIndexOf(46));
                containers.put(class_2960.method_60654((String)id), container);
            }
            catch (Exception e) {
                System.err.println("Failed to parse: " + String.valueOf(identifier));
                e.printStackTrace();
            }
        }
        WeaponRegistry.containers = containers;
    }

    public static WeaponAttributes resolveAttributes(class_2960 itemId, AttributesContainer container) {
        try {
            ArrayList<WeaponAttributes> resolutionChain = new ArrayList<WeaponAttributes>();
            AttributesContainer current = container;
            while (current != null) {
                resolutionChain.add(0, current.attributes());
                if (current.parent() != null) {
                    current = containers.get(class_2960.method_60654((String)current.parent()));
                    continue;
                }
                current = null;
            }
            WeaponAttributes empty = WeaponAttributes.empty();
            WeaponAttributes resolvedAttributes = resolutionChain.stream().reduce(empty, (a, b) -> {
                if (b == null) {
                    return a;
                }
                return WeaponAttributesHelper.override(a, b);
            });
            WeaponAttributesHelper.validate(resolvedAttributes);
            return resolvedAttributes;
        }
        catch (Exception e) {
            LOGGER.error("Failed to resolve weapon attributes for: " + String.valueOf(itemId) + ". Reason: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static void resolveAndRegisterAttributes(class_2960 itemId, AttributesContainer container) {
        WeaponAttributes resolvedAttributes = WeaponRegistry.resolveAttributes(itemId, container);
        if (resolvedAttributes != null) {
            WeaponRegistry.register(itemId, resolvedAttributes);
        }
    }

    public static void encodeRegistry() {
        boolean compressed = BetterCombatMod.config.weapon_registry_compression;
        ArrayList<String> chunks = new ArrayList<String>();
        SyncFormat syncContent = new SyncFormat();
        containers.forEach((key, value) -> syncContent.attributes.put(key.toString(), (AttributesContainer)value));
        registrations.forEach((key, value) -> syncContent.registrations.put(key.toString(), (WeaponAttributes)value));
        String json = gson.toJson((Object)syncContent);
        if (compressed) {
            json = CompressionHelper.gzipCompress(json);
        }
        if (BetterCombatMod.config.weapon_registry_logging) {
            LOGGER.info("Weapon Attribute assignments loaded: " + json);
        }
        for (int i = 0; i < json.length(); i += 10000) {
            chunks.add(json.substring(i, Math.min(json.length(), i + 10000)));
        }
        encodedRegistrations = new Encoded(compressed, chunks);
        Packets.WeaponRegistrySync referencePacket = new Packets.WeaponRegistrySync(compressed, chunks);
        class_2540 buffer = Platform.createByteBuffer();
        referencePacket.write(buffer);
        LOGGER.info("Encoded Weapon Attribute registry size (with package overhead): " + buffer.readableBytes() + " bytes (in " + chunks.size() + " string chunks with the size of 10000)");
    }

    public static void decodeRegistry(Packets.WeaponRegistrySync syncPacket) {
        boolean compressed = syncPacket.compressed();
        String json = "";
        for (String chunk : syncPacket.chunks()) {
            json = json.concat(chunk);
        }
        if (compressed) {
            json = CompressionHelper.gzipDecompress(json);
        }
        LOGGER.info("Decoded Weapon Attribute registry in " + syncPacket.chunks().size() + " string chunks");
        if (BetterCombatMod.config.weapon_registry_logging) {
            LOGGER.info("Weapon Attribute registry received: " + json);
        }
        SyncFormat sync = (SyncFormat)gson.fromJson(json, SyncFormat.class);
        containers.clear();
        sync.attributes.forEach((key, value) -> containers.put(class_2960.method_60654((String)key), (AttributesContainer)value));
        registrations.clear();
        sync.registrations.forEach((key, value) -> registrations.put(class_2960.method_60654((String)key), (WeaponAttributes)value));
    }

    public static Encoded getEncodedRegistry() {
        return encodedRegistrations;
    }

    public static class SyncFormat {
        public Map<String, AttributesContainer> attributes = new HashMap<String, AttributesContainer>();
        public Map<String, WeaponAttributes> registrations = new HashMap<String, WeaponAttributes>();
    }

    public record Encoded(boolean compressed, List<String> chunks) {
    }
}

